// Bridge for analog clock UVC in UVM-AMS

module osc_bridge
`ifdef XRUN
import cds_rnm_pkg::*;
`endif

`ifdef QUESTA
import mgc_rnm_pkg::*;
`endif

(
  input  wire osc_clk,
  output wire osc_clk_p,
  output wire osc_clk_n
  );

  //UVM + MS extras
  import uvm_pkg::*;
  import uvm_ms_pkg::*;
  `include "uvm_macros.svh"
  `include "uvm_ms.svh"
  
  //UVM package for this component
  import osc_pkg::*;

  //Selection bit to choose between single-ended clock and differential clock
  parameter bit diff_sel = 0;
  parameter passive = 0;

  //Class osc_bridge_proxy extends the osc_proxy included in osc_pkg.sv
  //The implementation for the config_wave push function is defined here
  class osc_bridge_proxy extends osc_proxy;
    function new(string name = "");
      super.new(name);
    endfunction : new
  
    // implementation of pull function from base class not needed
    // implementation of push function from base class
    function void push(input real ampl, bias, freq, input bit enable);
      core.ampl_in  = ampl;
      core.bias_in  = bias;
      core.freq_in  = freq;
      core.enable   = enable;
    endfunction

  endclass
  
  osc_bridge_proxy proxy = new("proxy");

  //Connections from proxy to core
  always @(proxy.delay_in, proxy.duration_in, proxy.sampling_do) begin
    core.delay_in = proxy.delay_in;
    core.duration_in = proxy.duration_in;
    core.sampling_do = proxy.sampling_do;
  end
  
  //Connections from core to proxy
  always_comb begin  
    proxy.sampling_done = core.sampling_done;
    proxy.ampl_out = core.ampl_out;
    proxy.bias_out = core.bias_out;
    proxy.freq_out = core.freq_out;
  end
  
  //Bridge core instantiation
  osc_bridge_core #(.diff_sel(diff_sel), .passive(passive)) core (
    .osc_clk(osc_clk),
    .osc_clk_p(osc_clk_p),
    .osc_clk_n(osc_clk_n)  
    );

endmodule 
