class i2c_packet extends uvm_sequence_item;
  // Protocol data
  rand bit [7:0] reg_addr;
  rand bit [7:0] data;
  rand bit [6:0] tg_addr;
  rand bit rw_;

  typedef enum bit {VALID_TG_ADDR, INVALID_TG_ADDR} tg_addr_type_t;
  typedef enum bit {VALID_REG_ADDR, INVALID_REG_ADDR} reg_addr_type_t;
  rand tg_addr_type_t tg_addr_valid; // always true (defined as default until after randomize)
  rand reg_addr_type_t reg_addr_valid;
  
  parameter tg_id = 7'b100_1101;

  rand int packet_delay;
  // Register with factory
  `uvm_object_utils_begin(i2c_packet)
    `uvm_field_int(tg_addr, UVM_ALL_ON + UVM_HEX)
    `uvm_field_int(rw_, UVM_ALL_ON + UVM_BIN)
    `uvm_field_int(reg_addr, UVM_ALL_ON + UVM_HEX)
    `uvm_field_int(data, UVM_ALL_ON + UVM_HEX)
  `uvm_object_utils_end

  // Constraints on reg_addr and tg_addr?
  constraint tg_addr_bound {(tg_addr_valid == VALID_TG_ADDR) -> tg_addr == tg_id;}
  constraint reg_addr_bound {(reg_addr_valid == VALID_REG_ADDR) -> reg_addr inside {[0:2]};}
  constraint packet_delay_bound {packet_delay >= 0; packet_delay < 21;}

  function new(string name = "i2c_packet"); 
    super.new(name);
  endfunction

endclass
