// This *.f file is meant to be run in the xrun_ams_sim directory
//-64
//-timescale 1ns/1fs
//-vtimescale 1ns/1fs

+UVM_VERBOSITY=UVM_MEDIUM
+UVM_TESTNAME=default_sequence_ms_test

// include directories
+incdir+../../uvc_lib/osc/sv/
+incdir+../../uvc_lib/registers/sv/
+incdir+../../includes/
 
// compile files
../../includes/uvm_ms_pkg.sv
../../uvc_lib/osc/sv/osc_pkg.sv
../../uvc_lib/registers/sv/registers_pkg.sv

// Analog resource
../../uvc_lib/osc/sv/osc_bridge.sv
// for SVRNM DUT
../../uvc_lib/osc/vams/osc_bridge_core.vams

// virtual interfaces
../../uvc_lib/osc/sv/osc_if.sv
../../uvc_lib/registers/sv/registers_if.sv

// DUT
+incdir+../../src_vams/
../../src_vams/ana_buf.vams
../../src_vams/clk_driver_diff.vams
../../src_vams/frequency_adapter.vams
../../src_vams/freq_div2.vams
../../src_vams/freq_doubler.vams
../../src_vams/mux4to1.vams
../../src_dig/registers.sv

+define+UVM_AMS
+incdir+../
+incdir+${XA_HOME}/include
../top.sv
-top top 


+lint=all,noNS,noSVA-AECASR 

+warn=all 

-lca
-xlrm floating_pnt_constraint
-xlrm real_cg
+ntb_solver_distribution=linear

-ucli 
-do ../vcs.do

-ntb_opts uvm


-timescale=1ns/1fs

-sverilog
-sv_interconnect
+systemverilogext+sv+svh

-debug_access+all

-R
+ad=../vcsAD.init
//+ad=../psim.init
-ams
-adopt absdelta
-ams_discipline logic
-kdb
-l vcs.log
//+define+_AEVENT_IN_CONDTIONAL
/*
Error-[MSV-DBC-AECFICS] Error in digital behavioral code
../../uvc_lib/osc/vams/osc_bridge_core.vams, 295
clk_detector, "cross((V(osc_clk) - vth), (+1), t_tol)"
  Analog event control functions cannot be used inside the following 
  conditional statements
   'if', 'case', 'casex', 'repeat' and 'while' statements.
*/

//+define+_SV_VAMS_PARAM_TRANSLATION 
// Passing bit parameter value into VAMS is troublesome, need fix from MSV

+define+_REAL_COV_GROUP
/*real number in cg 
Warning-[FCPEFRC] Precision Error For Real Coverpoint
../freq_adpt_scoreboard.sv, 67
  Precision overflow occurred for the range expr '0.9'. Scaling factor is 1.
  This value will be adjusted as per the precision.
*/
//+define+_REAL_CROSS_COV
/*
Error-[FCCORCNS] Cross Of Real Coverpoints Not Supported
../freq_adpt_scoreboard.sv, 85
top, "ALL_INPUT_COMB_cov"
  Cross coverage of real coverpoints is not supported.
*/
