// This *.f file is meant to be run in the xrun_ams_sim directory
//-64
//-timescale 1ns/1fs
//-vtimescale 1ns/1fs


// include directories
+define+VCS
${VCS_HOME}/etc/snps_msv/snps_msv_nettype_pkg.svp
${VCS_HOME}/etc/snps_msv/viz_library/viz_package.sv
+incdir+../../uvc_lib/osc/sv/
+incdir+../../uvc_lib/i2c/sv/
+incdir+../../includes/

// compile files
../../includes/uvm_ms_pkg.sv
../../uvc_lib/osc/sv/osc_pkg.sv
../../uvc_lib/i2c/sv/state_vars_pkg.sv
../../uvc_lib/i2c/sv/i2c_pkg.sv


// Analog resource
// for SVRNM DUT
../../uvc_lib/i2c/sv/i2c_bridge.sv
../../uvc_lib/i2c/sv/i2c_bridge_core.sv

../../uvc_lib/osc/sv/osc_bridge.sv
../../uvc_lib/osc/sv/osc_bridge_core.sv

// virtual interfaces
../../uvc_lib/osc/sv/osc_if.sv
../../uvc_lib/i2c/sv/i2c_if.sv

// DUT
../../src_svrnm/common_functions.sv
../../src_svrnm/slew.sv
../../src_svrnm/buffer.sv
../../src_svrnm/clk_driver_diff.sv
../../src_svrnm/freq_adapter.sv
../../src_svrnm/freq_div2.sv
../../src_svrnm/freq_doubler.sv
../../src_svrnm/mux4to1.sv
../../src_svrnm/I2C_target_ms.sv
../../src_dig/I2C_registers.sv

+define+UVM_AMS
+incdir+../
../CapGeq0.sv
../top.sv

//+SVSEED=random

//-coverage U -covoverwrite
//-input probes.tcl
//-run -exit

//../amscf.scs

//RNM Coercion is used to change the nettypes of top.{clk_in,clkout_p, clkout_n} from "wire" to "wreal"
//This is a Cadence Xcelium Mixed Signal App feature, and for non-Cadence simulators, will need either:
//* an equivalent feature to coercion, OR
//* an update to the ../top.sv and ../../uvc_lib/osc/sv/osc_bridge.sv files
//!
-coerce
-ucli -do ../vcs.do \
+UVM_VERBOSITY=UVM_MEDIUM 
+UVM_TESTNAME=default_sequence_ms_test 
-R
-lca
-xlrm floating_pnt_constraint
-xlrm real_cg 
//+define+WREAL4STATE 
//-realport
//-wreal res_def
-ntb_opts uvm


-timescale=1ns/1fs

-sverilog
-sv_interconnect
+systemverilogext+sv+svh

-debug_access+all 
-kdb
-l vcs.log
//+define+_AEVENT_IN_CONDTIONAL
/*
Error-[MSV-DBC-AECFICS] Error in digital behavioral code
../../uvc_lib/osc/vams/osc_bridge_core.vams, 295
clk_detector, "cross((V(osc_clk) - vth), (+1), t_tol)"
  Analog event control functions cannot be used inside the following 
  conditional statements
   'if', 'case', 'casex', 'repeat' and 'while' statements.
*/

//+define+_SV_VAMS_PARAM_TRANSLATION 
// Passing bit parameter value into VAMS is troublesome, need fix from MSV

//+define+_REAL_COV_GROUP
/*real number in cg 
Warning-[FCPEFRC] Precision Error For Real Coverpoint
../freq_adpt_scoreboard.sv, 84
  Precision overflow occurred for the range expr '0.9'. Scaling factor is 1.
  This value will be adjusted as per the precision.
*/
//+define+_REAL_CROSS_COV
/*
Error-[FCCORCNS] Cross Of Real Coverpoints Not Supported
../freq_adpt_scoreboard.sv, 85
top, "ALL_INPUT_COMB_cov"
  Cross coverage of real coverpoints is not supported.
*/