-- ****************************************************************************
-- ** Leon 2 code
-- ** Revision:    $Revision: 1506 $
-- ** Date:        $Date: 2009-04-25 23:51:56 -0700 (Sat, 25 Apr 2009) $
-- ** 
-- ** Copyright (c) 2008, 2009 The SPIRIT Consortium.
-- ** 
-- ** This work forms part of a deliverable of The SPIRIT Consortium.
-- ** 
-- ** Use of these materials are governed by the legal terms and conditions
-- ** outlined in the disclaimer available from www.spiritconsortium.org.
-- ** 
-- ** This source file is provided on an AS IS basis.  The SPIRIT
-- ** Consortium disclaims any warranty express or implied including
-- ** any warranty of merchantability and fitness for use for a
-- ** particular purpose.
-- ** 
-- ** The user of the source file shall indemnify and hold The SPIRIT
-- ** Consortium and its members harmless from any damages or liability.
-- ** Users are requested to provide feedback to The SPIRIT Consortium
-- ** using either mailto:feedback@lists.spiritconsortium.org or the forms at 
-- ** http://www.spiritconsortium.org/about/contact_us/
-- ** 
-- ** This file may be copied, and distributed, with or without
-- ** modifications; this notice must be included on any copy.
-- ****************************************************************************
-- Derived from European Space Agency (ESA) code as described below
----------------------------------------------------------------------------
--  This file is a part of the LEON VHDL model
--  Copyright (C) 1999  European Space Agency (ESA)
--
--  This library is free software; you can redistribute it and/or
--  modify it under the terms of the GNU Lesser General Public
--  License as published by the Free Software Foundation; either
--  version 2 of the License, or (at your option) any later version.
--
--  See the file COPYING.LGPL for the full details of the license.


-----------------------------------------------------------------------------
-- Entity: 	device
-- File:	device.vhd
-- Author:	Jiri Gaisler - Gaisler Research
-- Description:	package to select current device configuration
------------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;
use work.target.all;

package device is

-----------------------------------------------------------------------------
-- Automatically generated by tkonfig/mkdevice
-----------------------------------------------------------------------------

  constant apbslvcfg_tkconfig : apb_slv_config_vector(0 to APB_SLV_MAX-1) := (
  --   first         last      index  enable     function           PADDR[9:0]
  ( "000000000000000000", "000000000000001000",  0,   true), -- memory controller, 0x00 - 0x08
  ( "000000000000001100", "000000000000010000",  1,   false), -- AHB status reg.,   0x0C - 0x10
  ( "000000000000010100", "000000000000011000",  2,   true), -- cache controller,  0x14 - 0x18
  ( "000000000000011100", "000000000000100000",  3,   false), -- write protection,  0x1C - 0x20
  ( "000000000000100100", "000000000000100100",  4,   true), -- config register,   0x24 - 0x24
  ( "000000000001000000", "000000000001101100",  5,   true), -- timers,            0x40 - 0x6C
  ( "000000000001110000", "000000000001111100",  6,   true), -- uart1,             0x70 - 0x7C
  ( "000000000010000000", "000000000010001100",  7,   true), -- uart2,             0x80 - 0x8C
  ( "000000000010010000", "000000000010011100",  8,   true), -- interrupt ctrl     0x90 - 0x9C
  ( "000000000010100000", "000000000010101100",  9,   true), -- I/O port           0xA0 - 0xAC
  ( "000000000010110000", "000000000010111100", 10,   false),-- 2nd interrupt ctrl 0xB0 - 0xBC
  ( "000000000011000000", "000000000011001100", 11,   false), -- DSU uart           0xC0 - 0xCC
  ( "000000000100000000", "000000000111111100", 12,   false), -- PCI configuration  0x100- 0x1FC
  ( "000000001000000000", "000000001011111100", 13,   false), -- PCI arbiter        0x200- 0x2FC
     others => apb_slv_config_void);

  constant apb_tkconfig  : apb_config_type := (table => apbslvcfg_tkconfig);

  constant ahbslvcfg_tkconfig : ahb_slv_config_vector(0 to AHB_SLV_MAX-1) := (
  -- first    last  index  split  enable  function            HADDR[31:28]
    ("0000", "0111",  0,   false, true), -- memory controller,   0x0- 0x7
    ("1000", "1000",  1,   false, true), -- APB bridge, 128 MB   0x8- 0x8
    ("1001", "1001",  2,   false, false), -- DSU         128 MB   0x9- 0x9
    ("1010", "1111",  3,   false, false), -- PCI initiator        0xA- 0xF
      others => ahb_slv_config_void);

  constant ahb_tkconfig : ahb_config_type := ( masters => 1, defmst => 0,
    split => false, slvtable => ahbslvcfg_tkconfig, testmod => false);

  constant syn_tkconfig : syn_config_type := (  
    targettech => gen, infer_pads => false,
    infer_ram => false, infer_regf => false, infer_rom => true,
    infer_mult => false, rftype => 1);

  constant iu_tkconfig : iu_config_type := (
    nwindows => 8, multiplier => none, divider => none, mac => false,
    fpuen => 0, cpen => false, fastjump => false, icchold => false, 
    lddelay => 1, fastdecode => false, watchpoints => 0, impl => 0,
    version => 0, rflowpow => false);

  constant fpu_tkconfig : fpu_config_type := 
    (core => meiko, interface => none, fregs => 0, version => 0);

  constant cache_tkconfig : cache_config_type := ( icachesize => 2,
    ilinesize => 4, dcachesize => 2, dlinesize => 4, dsnoop => none,
    cachetable => cachetbl_std);

  constant mctrl_tkconfig : mctrl_config_type := (
    bus8en => false, bus16en => false, wendfb => false, ramsel5 => false,
    sdramen => false, sdinvclk => false);

  constant peri_tkconfig : peri_config_type := (
    cfgreg => true, ahbstat => false, wprot => false, wdog => false, 
    irq2cfg => irq2none);

  constant debug_tkconfig : debug_config_type := ( enable => true, uart => false, 
    iureg => false, fpureg => false, nohalt => false, pclow => 2,
    dsuenable => false, dsutrace => false, dsumixed => false,
    dsudpram => false, tracelines => 64);

  constant boot_tkconfig : boot_config_type := (boot => memory, ramrws => 0,
    ramwws => 0, sysclk => 25000000, baud => 19200, extbaud => false,
    pabits => 11);

  constant pci_tkconfig : pci_config_type := (
    pcicore => none, ahbmasters => 0, ahbslaves => 0,
    arbiter => false, fixpri => false, prilevels => 4, pcimasters => 4,
    vendorid => 16#0000#, deviceid => 16#0000#, subsysid => 16#0000#,
    revisionid => 16#00#, classcode =>16#000000#, pmepads => false,
    p66pad => false, pcirstall => false);

  constant tkconfig : config_type := (
    synthesis => syn_tkconfig, iu => iu_tkconfig, fpu => fpu_tkconfig, 
    cp => cp_none, cache => cache_tkconfig, ahb => ahb_tkconfig,
    apb => apb_tkconfig, mctrl => mctrl_tkconfig, boot => boot_tkconfig,
    debug => debug_tkconfig, pci => pci_tkconfig, peri => peri_tkconfig);

-----------------------------------------------------------------------------
-- end of automatic configuration
-----------------------------------------------------------------------------


----------------------------------------------------------------------
-- This is the current device configuration
----------------------------------------------------------------------
  constant conf : config_type := tkconfig;
--  constant conf : config_type := fpga_2k2k;
--  constant conf : config_type := fpga_2k2k_v8;
--  constant conf : config_type := fpga_2k2k_irq2;
--  constant conf : config_type := fpga_2k2k_softprom;
--  constant conf : config_type := fpga_2k2k_v8_softprom;
--  constant conf : config_type := fpga_4k4k_v8_fpu;
--  constant conf : config_type := fpga_4k4k_v8_fpu_softprom;
--  constant conf : config_type := fpga_2k2k_v8_mac_softprom;
--  constant conf : config_type := virtex_2k2k_blockprom;
--  constant conf : config_type := virtex_4k2k_dsu;
--  constant conf : config_type := virtex_4k2k_dsu_sdram;
--  constant conf : config_type := virtex_4k2k_dsu_sdram_invclk;
--  constant conf : config_type := virtex_8k8k_dsu_pci_actel_sdram;
--  constant conf : config_type := virtex_8k8k_dsu_pci_actel_sdram_v8_fpu;
--  constant conf : config_type := virtex_8k8k_dsu_pci_is_sdram_invclk;
--  constant conf : config_type := virtex_4k2k_dsu_pci;
--  constant conf : config_type := virtex_4k2k_v8_dsu;
--  constant conf : config_type := virtex_2k2k_v8_fpu_dsu;
--  constant conf : config_type := virtex_2k1k_rdbmon;
--  constant conf : config_type := virtex_2k2k_v8_blockprom;
--  constant conf : config_type := gen_atc25;
--  constant conf : config_type := gen_atc25_meiko;
--  constant conf : config_type := gen_atc25_fpc;
--  constant conf : config_type := gen_atc25_insilicon_pci;
--  constant conf : config_type := gen_atc35;
--  constant conf : config_type := systel_fpga;
--  constant conf : config_type := systel_asic;
--  constant conf : config_type := gen_fs90;
--  constant conf : config_type := gen_umc18;
--  constant conf : config_type := gen_tsmc25_8k8k;


end;
